<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Blue color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface BlueColorProviderInterface extends ColorProviderInterface {

    /**
     * Blue color "100"
     *
     * @var string
     */
    const BLUE_COLOR_100 = "#BBDEFB";

    /**
     * Blue color "200"
     *
     * @var string
     */
    const BLUE_COLOR_200 = "#90CAF9";

    /**
     * Blue color "300"
     *
     * @var string
     */
    const BLUE_COLOR_300 = "#64B5F6";

    /**
     * Blue color "400"
     *
     * @var string
     */
    const BLUE_COLOR_400 = "#42A5F5";

    /**
     * Blue color "50"
     *
     * @var string
     */
    const BLUE_COLOR_50 = "#E3F2FD";

    /**
     * Blue color "500"
     *
     * @var string
     */
    const BLUE_COLOR_500 = "#2196F3";

    /**
     * Blue color "600"
     *
     * @var string
     */
    const BLUE_COLOR_600 = "#1E88E5";

    /**
     * Blue color "700"
     *
     * @var string
     */
    const BLUE_COLOR_700 = "#1976D2";

    /**
     * Blue color "800"
     *
     * @var string
     */
    const BLUE_COLOR_800 = "#1565C0";

    /**
     * Blue color "900"
     *
     * @var string
     */
    const BLUE_COLOR_900 = "#0D47A1";

    /**
     * Blue color "A100"
     *
     * @var string
     */
    const BLUE_COLOR_A100 = "#82B1FF";

    /**
     * Blue color "A200"
     *
     * @var string
     */
    const BLUE_COLOR_A200 = "#448AFF";

    /**
     * Blue color "A400"
     *
     * @var string
     */
    const BLUE_COLOR_A400 = "#2979FF";

    /**
     * Blue color "A700"
     *
     * @var string
     */
    const BLUE_COLOR_A700 = "#2962FF";

    /**
     * Blue color name.
     *
     * @var string
     */
    const BLUE_COLOR_NAME = "blue";
}
