<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Brown color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface BrownColorProviderInterface extends ColorProviderInterface {

    /**
     * Brown color "100"
     *
     * @var string
     */
    const BROWN_COLOR_100 = "#D7CCC8";

    /**
     * Brown color "200"
     *
     * @var string
     */
    const BROWN_COLOR_200 = "#BCAAA4";

    /**
     * Brown color "300"
     *
     * @var string
     */
    const BROWN_COLOR_300 = "#A1887F";

    /**
     * Brown color "400"
     *
     * @var string
     */
    const BROWN_COLOR_400 = "#8D6E63";

    /**
     * Brown color "50"
     *
     * @var string
     */
    const BROWN_COLOR_50 = "#EFEBE9";

    /**
     * Brown color "500"
     *
     * @var string
     */
    const BROWN_COLOR_500 = "#795548";

    /**
     * Brown color "600"
     *
     * @var string
     */
    const BROWN_COLOR_600 = "#6D4C41";

    /**
     * Brown color "700"
     *
     * @var string
     */
    const BROWN_COLOR_700 = "#5D4037";

    /**
     * Brown color "800"
     *
     * @var string
     */
    const BROWN_COLOR_800 = "#4E342E";

    /**
     * Brown color "900"
     *
     * @var string
     */
    const BROWN_COLOR_900 = "#3E2723";

    /**
     * Brown color name.
     *
     * @var string
     */
    const BROWN_COLOR_NAME = "brown";
}
