<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Deep purple color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface DeepPurpleColorProviderInterface extends ColorProviderInterface {

    /**
     * Deep purple color "100"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_100 = "#D1C4E9";

    /**
     * Deep purple color "200"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_200 = "#B39DDB";

    /**
     * Deep purple color "300"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_300 = "#9575CD";

    /**
     * Deep purple color "400"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_400 = "#7E57C2";

    /**
     * Deep purple color "50"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_50 = "#EDE7F6";

    /**
     * Deep purple color "500"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_500 = "#673AB7";

    /**
     * Deep purple color "600"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_600 = "#5E35B1";

    /**
     * Deep purple color "700"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_700 = "#512DA8";

    /**
     * Deep purple color "800"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_800 = "#4527A0";

    /**
     * Deep purple color "900"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_900 = "#311B92";

    /**
     * Deep purple color "A100"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_A100 = "#B388FF";

    /**
     * Deep purple color "A200"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_A200 = "#7C4DFF";

    /**
     * Deep purple color "A400"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_A400 = "#651FFF";

    /**
     * Deep purple color "A700"
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_A700 = "#6200EA";

    /**
     * Deep purpple color name.
     *
     * @var string
     */
    const DEEP_PURPLE_COLOR_NAME = "deep-purple";
}
