<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Green color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface GreenColorProviderInterface extends ColorProviderInterface {

    /**
     * Green color "100"
     *
     * @var string
     */
    const GREEN_COLOR_100 = "#C8E6C9";

    /**
     * Green color "200"
     *
     * @var string
     */
    const GREEN_COLOR_200 = "#A5D6A7";

    /**
     * Green color "300"
     *
     * @var string
     */
    const GREEN_COLOR_300 = "#81C784";

    /**
     * Green color "400"
     *
     * @var string
     */
    const GREEN_COLOR_400 = "#66BB6A";

    /**
     * Green color "50"
     *
     * @var string
     */
    const GREEN_COLOR_50 = "#E8F5E9";

    /**
     * Green color "500"
     *
     * @var string
     */
    const GREEN_COLOR_500 = "#4CAF50";

    /**
     * Green color "600"
     *
     * @var string
     */
    const GREEN_COLOR_600 = "#43A047";

    /**
     * Green color "700"
     *
     * @var string
     */
    const GREEN_COLOR_700 = "#388E3C";

    /**
     * Green color "800"
     *
     * @var string
     */
    const GREEN_COLOR_800 = "#2E7D32";

    /**
     * Green color "900"
     *
     * @var string
     */
    const GREEN_COLOR_900 = "#1B5E20";

    /**
     * Green color "A100"
     *
     * @var string
     */
    const GREEN_COLOR_A100 = "#B9F6CA";

    /**
     * Green color "A200"
     *
     * @var string
     */
    const GREEN_COLOR_A200 = "#69F0AE";

    /**
     * Green color "A400"
     *
     * @var string
     */
    const GREEN_COLOR_A400 = "#00E676";

    /**
     * Green color "A700"
     *
     * @var string
     */
    const GREEN_COLOR_A700 = "#00C853";

    /**
     * Green color name.
     *
     * @var string
     */
    const GREEN_COLOR_NAME = "green";
}
