<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Light green color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface LightGreenColorProviderInterface extends ColorProviderInterface {

    /**
     * Light green color "100"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_100 = "#DCEDC8";

    /**
     * Light green color "200"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_200 = "#C5E1A5";

    /**
     * Light green color "300"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_300 = "#AED581";

    /**
     * Light green color "400"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_400 = "#9CCC65";

    /**
     * Light green color "50"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_50 = "#F1F8E9";

    /**
     * Light green color "500"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_500 = "#8BC34A";

    /**
     * Light green color "600"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_600 = "#7CB342";

    /**
     * Light green color "700"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_700 = "#689F38";

    /**
     * Light green color "800"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_800 = "#558B2F";

    /**
     * Light green color "900"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_900 = "#33691E";

    /**
     * Light green color "A100"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_A100 = "#CCFF90";

    /**
     * Light green color "A200"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_A200 = "#B2FF59";

    /**
     * Light green color "A400"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_A400 = "#76FF03";

    /**
     * Light green color "A700"
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_A700 = "#64DD17";

    /**
     * Light green color name.
     *
     * @var string
     */
    const LIGHT_GREEN_COLOR_NAME = "light-green";
}
