<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class NlpSemanticParsingNumberFractionNumber extends \Google\Model
{
  protected $denominatorType = NlpSemanticParsingNumberSimpleNumber::class;
  protected $denominatorDataType = '';
  public $denominator;
  protected $numeratorType = NlpSemanticParsingNumberSimpleNumber::class;
  protected $numeratorDataType = '';
  public $numerator;
  /**
   * @var int
   */
  public $precision;
  protected $wholeNumberType = NlpSemanticParsingNumberSimpleNumber::class;
  protected $wholeNumberDataType = '';
  public $wholeNumber;

  /**
   * @param NlpSemanticParsingNumberSimpleNumber
   */
  public function setDenominator(NlpSemanticParsingNumberSimpleNumber $denominator)
  {
    $this->denominator = $denominator;
  }
  /**
   * @return NlpSemanticParsingNumberSimpleNumber
   */
  public function getDenominator()
  {
    return $this->denominator;
  }
  /**
   * @param NlpSemanticParsingNumberSimpleNumber
   */
  public function setNumerator(NlpSemanticParsingNumberSimpleNumber $numerator)
  {
    $this->numerator = $numerator;
  }
  /**
   * @return NlpSemanticParsingNumberSimpleNumber
   */
  public function getNumerator()
  {
    return $this->numerator;
  }
  /**
   * @param int
   */
  public function setPrecision($precision)
  {
    $this->precision = $precision;
  }
  /**
   * @return int
   */
  public function getPrecision()
  {
    return $this->precision;
  }
  /**
   * @param NlpSemanticParsingNumberSimpleNumber
   */
  public function setWholeNumber(NlpSemanticParsingNumberSimpleNumber $wholeNumber)
  {
    $this->wholeNumber = $wholeNumber;
  }
  /**
   * @return NlpSemanticParsingNumberSimpleNumber
   */
  public function getWholeNumber()
  {
    return $this->wholeNumber;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NlpSemanticParsingNumberFractionNumber::class, 'Google_Service_Contentwarehouse_NlpSemanticParsingNumberFractionNumber');
