<?php

/** --------------------------------------------------------------------------------
 * This classes renders the response for the [update] process for the estimates
 * controller
 * @package    Grow CRM
 * @author     NextLoop
 *----------------------------------------------------------------------------------*/

namespace App\Http\Responses\Estimates;
use Illuminate\Contracts\Support\Responsable;

class UpdateTaxtypeResponse implements Responsable {

    private $payload;

    public function __construct($payload = array()) {
        $this->payload = $payload;
    }

    /**
     * render the view for estimates
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function toResponse($request) {

        //set all data to arrays
        foreach ($this->payload as $key => $value) {
            $$key = $value;
        }

        request()->session()->flash('success-notification-long', __('lang.request_has_been_completed'));

        $jsondata['redirect_url'] = url("/estimates/$bill_id/edit-estimate");

        //response
        return response()->json($jsondata);

    }

}
