<?php

/** --------------------------------------------------------------------------------
 * This classes renders the response for the [pdf] process for the expenses
 * controller
 * @package    Grow CRM
 * @author     NextLoop
 *----------------------------------------------------------------------------------*/

namespace App\Http\Responses\Expenses;
use Illuminate\Contracts\Support\Responsable;
use PDF;

class PDFResponse implements Responsable {

    private $payload;

    public function __construct($payload = array()) {
        $this->payload = $payload;
    }

    /**
     * render the view
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function toResponse($request) {

        //set all data to arrays
        foreach ($this->payload as $key => $value) {
            $$key = $value;
        }

        $pdf = PDF::loadView('pages/bill/wrapper-pdf', compact('page', 'invoice', 'taxrates', 'taxes', 'elements'));
        return $pdf->download('invoice.pdf');

    }
}
