<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Amber color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface AmberColorProviderInterface extends ColorProviderInterface {

    /**
     * Amber color "100"
     *
     * @var string
     */
    const AMBER_COLOR_100 = "#FFECB3";

    /**
     * Amber color "200"
     *
     * @var string
     */
    const AMBER_COLOR_200 = "#FFE082";

    /**
     * Amber color "300"
     *
     * @var string
     */
    const AMBER_COLOR_300 = "#FFD54F";

    /**
     * Amber color "400"
     *
     * @var string
     */
    const AMBER_COLOR_400 = "#FFCA28";

    /**
     * Amber color "50"
     *
     * @var string
     */
    const AMBER_COLOR_50 = "#FFF8E1";

    /**
     * Amber color "500"
     *
     * @var string
     */
    const AMBER_COLOR_500 = "#FFC107";

    /**
     * Amber color "600"
     *
     * @var string
     */
    const AMBER_COLOR_600 = "#FFB300";

    /**
     * Amber color "700"
     *
     * @var string
     */
    const AMBER_COLOR_700 = "#FFA000";

    /**
     * Amber color "800"
     *
     * @var string
     */
    const AMBER_COLOR_800 = "#FF8F00";

    /**
     * Amber color "900"
     *
     * @var string
     */
    const AMBER_COLOR_900 = "#FF6F00";

    /**
     * Amber color "A100"
     *
     * @var string
     */
    const AMBER_COLOR_A100 = "#FFE57F";

    /**
     * Amber color "A200"
     *
     * @var string
     */
    const AMBER_COLOR_A200 = "#FFD740";

    /**
     * Amber color "A400"
     *
     * @var string
     */
    const AMBER_COLOR_A400 = "#FFC400";

    /**
     * Amber color "A700"
     *
     * @var string
     */
    const AMBER_COLOR_A700 = "#FFAB00";

    /**
     * Amber color name.
     *
     * @var string
     */
    const AMBER_COLOR_NAME = "amber";
}
