<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Blue grey color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface BlueGreyColorProviderInterface extends ColorProviderInterface {

    /**
     * Blue grey color "100"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_100 = "#CFD8DC";

    /**
     * Blue grey color "200"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_200 = "#B0BEC5";

    /**
     * Blue grey color "300"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_300 = "#90A4AE";

    /**
     * Blue grey color "400"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_400 = "#78909C";

    /**
     * Blue grey color "50"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_50 = "#ECEFF1";

    /**
     * Blue grey color "500"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_500 = "#607D8B";

    /**
     * Blue grey color "600"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_600 = "#546E7A";

    /**
     * Blue grey color "700"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_700 = "#455A64";

    /**
     * Blue grey color "800"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_800 = "#37474F";

    /**
     * Blue grey color "900"
     *
     * @var string
     */
    const BLUE_GREY_COLOR_900 = "#263238";

    /**
     * Blue grey color name.
     *
     * @var string
     */
    const BLUE_GREY_COLOR_NAME = "blue-grey";
}
