<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Red color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface RedColorProviderInterface extends ColorProviderInterface {

    /**
     * Red color "100"
     *
     * @var string
     */
    const RED_COLOR_100 = "#FFCDD2";

    /**
     * Red color "200"
     *
     * @var string
     */
    const RED_COLOR_200 = "#EF9A9A";

    /**
     * Red color "300"
     *
     * @var string
     */
    const RED_COLOR_300 = "#E57373";

    /**
     * Red color "400"
     *
     * @var string
     */
    const RED_COLOR_400 = "#EF5350";

    /**
     * Red color "50"
     *
     * @var string
     */
    const RED_COLOR_50 = "#FFEBEE";

    /**
     * Red color "500"
     *
     * @var string
     */
    const RED_COLOR_500 = "#F44336";

    /**
     * Red color "600"
     *
     * @var string
     */
    const RED_COLOR_600 = "#E53935";

    /**
     * Red color "700"
     *
     * @var string
     */
    const RED_COLOR_700 = "#D32F2F";

    /**
     * Red color "800"
     *
     * @var string
     */
    const RED_COLOR_800 = "#C62828";

    /**
     * Red color "900"
     *
     * @var string
     */
    const RED_COLOR_900 = "#B71C1C";

    /**
     * Red color "A100"
     *
     * @var string
     */
    const RED_COLOR_A100 = "#FF8A80";

    /**
     * Red color "A200"
     *
     * @var string
     */
    const RED_COLOR_A200 = "#FF5252";

    /**
     * Red color "A400"
     *
     * @var string
     */
    const RED_COLOR_A400 = "#FF1744";

    /**
     * Red color "A700"
     *
     * @var string
     */
    const RED_COLOR_A700 = "#D50000";

    /**
     * Red color name.
     *
     * @var string
     */
    const RED_COLOR_NAME = "red";
}
