<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\NetworkServices;

class GrpcRouteFaultInjectionPolicy extends \Google\Model
{
  protected $abortType = GrpcRouteFaultInjectionPolicyAbort::class;
  protected $abortDataType = '';
  public $abort;
  protected $delayType = GrpcRouteFaultInjectionPolicyDelay::class;
  protected $delayDataType = '';
  public $delay;

  /**
   * @param GrpcRouteFaultInjectionPolicyAbort
   */
  public function setAbort(GrpcRouteFaultInjectionPolicyAbort $abort)
  {
    $this->abort = $abort;
  }
  /**
   * @return GrpcRouteFaultInjectionPolicyAbort
   */
  public function getAbort()
  {
    return $this->abort;
  }
  /**
   * @param GrpcRouteFaultInjectionPolicyDelay
   */
  public function setDelay(GrpcRouteFaultInjectionPolicyDelay $delay)
  {
    $this->delay = $delay;
  }
  /**
   * @return GrpcRouteFaultInjectionPolicyDelay
   */
  public function getDelay()
  {
    return $this->delay;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GrpcRouteFaultInjectionPolicy::class, 'Google_Service_NetworkServices_GrpcRouteFaultInjectionPolicy');
